*
* TCP OUTPUT FUNCTIONS FOR MARINA IP.
* BY D. FINNIGAN - 22 DEC 2015
*
* SEND A TCP RESET SEGMENT
* PTR NEEDS TO POINT TO THE TCP HEADER OF THE
* SEGMENT THAT WE ARE SENDING THIS RESET IN RESPONSE
* TO.
*
TCPSENDRESET
* DON'T SEND RESET FOR A RESET
 LDY #13 ; POINT TO CONTROL BITS
 LDA (PTR),Y
 AND #%00000100 ; MASK RST FLAG
 BEQ :N
 CLC ; THIS WAS A RESET
 RTS
*
* PREPARE THE IP HEADER
*
:N
 LDA #0
 STA OUTPLEN ; NO PAYLOAD; JUST TCP HEAD
 LDY #18 ; IP ID
 STA OUTPHEAD,Y
 INY
 STA OUTPHEAD,Y
 LDY #22 ; IP TTL
 STA OUTPHEAD,Y
 INY
 LDA #PROTOTCP ; IP PROTOCOL
 STA OUTPHEAD,Y
 LDY #26 ; IP SOURCE
 LDA #1
 STA OUTPHEAD,Y
*
* COPY DESTINATION ADDRESS
*
 LDY #33 ; DESTINATION ADDRESS
 LDX #3
:L LDA IPINSRC,X
 STA OUTPHEAD,Y
 DEY
 DEX
 BPL :L
*
* SWAP SOURCE AMD DESTINATION TCP PORTS
*
 LDY #0 ; SOURCE PORT IN OLD
 LDX #36 ; DEST PORT IN OUTPHEAD
 LDA (PTR),Y
 STA OUTPHEAD,X
 INY
 LDA (PTR),Y
 INX
 STA OUTPHEAD,X
 INY
 LDX #34 ; SOURCE PORT IN OUTPHEAD
 LDA (PTR),Y ; DEST PORT IN OLD
 STA OUTPHEAD,X
 INY
 LDA (PTR),Y
 INX
 STA OUTPHEAD,X
*
* ZERO-OUT THE SEQUENCE NUMBER
*
 LDA #0
 LDY #3
 LDX #41 ; SEQ NUMBER
:L2 STA OUTPHEAD,X
 DEX
 DEY
 BPL :L2
*
* CHECK IF THE TCP SEGMENT CONTAINED AN ACK
*

*
* HEADER LENGTH
*
 LDA #20
 STA OUTPHLEN
 LDX #46
 STA OUTPHEAD,X
*
* FLAGS: ACK AND RST
*
 LDA #%00010100
 INX
 STA OUTPHEAD,X
*
* WINDOW SIZE: 0
*
 LDA #0
 INX
 STA OUTPHEAD,X
 INX
 STA OUTPHEAD,X
*
* COMPUTE TCP CHECKSUM
*

*
* SEND IT
*
 RTS  ; NOT WORKING YET
*
 JSR IPPREP
 BRK
 JSR IPSEND
 RTS
